#pragma once

#include "BowerShader.h"

using namespace std;
using namespace DirectX;

//A more complex depth shader specifically for calculating the depth of the terrain - this has to be tessellated and displaced identically to accurately calculate its depth
class TerrainDepthShader : public BowerShader
{
	public:
		TerrainDepthShader(ID3D11Device* device, HWND hwnd);
		~TerrainDepthShader();

		void setShaderParameters(ID3D11DeviceContext* deviceContext, const XMMATRIX &world, const XMMATRIX &view, const XMMATRIX &projection, XMFLOAT3 cameraPos, float minTessFactor, float maxTessFactor, ID3D11ShaderResourceView* displacementTexture);

	private:
		void initShader(const wchar_t* vsFilename, const wchar_t* psFilename);
		void initShader(const wchar_t* vsFilename, const wchar_t* hsFilename, const wchar_t* dsFilename, const wchar_t* psFilename);

		ID3D11Buffer* matrixBuffer;
		ID3D11Buffer* dynamicTessBuffer;
};
